unit Yurical;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, lrat, Stream, eval, Menus, DdeMan, IniFiles,
  bundisp, Clipbrd;

type
  Tfyurica = class(TForm)
    hist: TComboBox;
    ac: TButton;
    fraction: TButton;
    Label1: TLabel;
    Label2: TLabel;
    HelpButton: TButton;
    taibun: TButton;
    PopupMenu: TPopupMenu;
    KT1: TMenuItem;
    KC1: TMenuItem;
    KP1: TMenuItem;
    K1: TMenuItem;
    DDE: TDdeServerConv;
    YURI: TDdeServerItem;
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Show1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    Paste1: TMenuItem;
    N4: TMenuItem;
    J1: TMenuItem;
    E1: TMenuItem;
    SelectAll1: TMenuItem;
    Help1: TMenuItem;
    procedure OnKeyPress(Sender: TObject; var Key: Char);
    procedure acClick(Sender: TObject);
    procedure fractionClick(Sender: TObject);
    procedure taibunClick(Sender: TObject);
    procedure keisan;
    procedure OnCreate(Sender: TObject);
    procedure OnDestroy(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure OnResize(Sender: TObject);
    procedure eva(Sender: TObject);
    procedure maceval(Sender: TObject; Msg: TStrings);
    procedure Exit1Click(Sender: TObject);
    procedure OnShow(Sender: TObject);
    procedure histChange(Sender: TObject);
    procedure KT1Click(Sender: TObject);
    procedure KC1Click(Sender: TObject);
    procedure KP1Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure J1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    {procedure ddechange(Sender: TObject);}
  private
    { Private 錾 }
    Err: Boolean;
    Acc: TloRational;
    afterdde:boolean;
    first:boolean;
    last:boolean;
    procedure hisadd(s:string);
    procedure FileCalc;
    procedure IniWrite;
    procedure IniRead;
    function calc(shiki:string):string;
    function frac(shiki:string):string;
    function tai(shiki:string):string;
  public
    { Public 錾 }
    bd: TbunDisp;
  end;

var
  fyurica: Tfyurica;

implementation

{$R *.DFM}

{ ------------
  G^[
  ------------}
procedure Tfyurica.OnKeyPress(Sender: TObject; var Key: Char);
begin
     if ord(Key) = VK_RETURN then begin
         key := #0; {r[v炵}
         keisan;
     end;
end;

{ --------
  vZ{
  --------}
procedure Tfyurica.keisan;
var
   s:StringStream;
   t:String;
begin
   t := hist.text;
   hisadd(hist.text);
   s := StringStream.fromString(t+';');
   try
       Expression(Acc, s);
       Err := False;
       hist.text := Acc.asString;
       bd.text := hist.text+';';
   except on e:Exception do begin
       Err := True;
       hist.text := e.Message ;
       end;
   end;
   hist.selstart := length(hist.text);
   s.free;
end;

{ ------------
  ւ̒ǉ
  ------------}
procedure Tfyurica.hisadd(s:string);
var i:Integer;
    latest:boolean;
begin
   latest := false;
   for i := hist.Items.count-1 downto 0 do begin
       if hist.Items[i] = s then begin
           if i = 0 then begin
               latest := true;
           end else begin
               hist.Items.delete(i);
               break;
           end;
       end;
   end;
   if latest then begin
       exit;
   end;
   if hist.Items.count >= 10 then begin
       hist.Items.delete(9);
   end;
   hist.items.insert(0, s);
end;

{ ------------------
  `b{^NbN
  ------------------}
procedure Tfyurica.acClick(Sender: TObject);
begin
     if hist.text = 'DDE' then begin
         yuri.CopytoClipboard;
     end;
     hist.text := '0';
     bd.text := hist.text+';';
     acc.clear;
     hist.setfocus;
     hist.selstart := length(hist.text);
end;

{ ------------
  {^
  ------------}
procedure Tfyurica.fractionClick(Sender: TObject);
begin
    keisan;
    if (Acc <> nil) and (not Err) then begin
        if J1.Checked then begin
            hist.text := Acc.asFraction2(true);
        end else begin
            hist.text := Acc.asFraction2(false);
        end;
        bd.text := hist.text+';';
    end;
    hist.setfocus;
    hist.selstart := length(hist.text);
end;

{ ------------
  ѕ{^
  ------------}
procedure Tfyurica.taibunClick(Sender: TObject);
begin
    keisan;
    if (Acc <> nil) and (not Err) then begin
        hist.text := Acc.asTaibun;
        bd.text := hist.text+';';
    end;
    hist.setfocus;
    hist.selstart := length(hist.text);
end;

{ ------------
  
  ------------}
procedure Tfyurica.OnCreate(Sender: TObject);
begin
    Err := false;
    Acc := TloRational.Create(0,1);
    afterdde := false;
    HorzScrollBar.visible := false;
    VertScrollBar.visible := false;
    first := true;
    last := false;
    bd := TBunDisp.Create(Self);
    bd.Parent := Self;
    bd.top := hist.top+ hist.height + 10;
    bd.left := hist.Left;
    bd.width := hist.width;
    bd.text := '';
end;

{ ------------
  I
  ------------}
procedure Tfyurica.OnDestroy(Sender: TObject);
begin
    last := true;
    iniWrite;
    Acc.free;
    bd.free;
end;

{ ------------
  wv{^
  ------------}
procedure Tfyurica.HelpButtonClick(Sender: TObject);
begin
    Application.HelpCommand(HELP_CONTENTS, 0);
end;

{ ------------
  TCYύX
  ------------}
procedure Tfyurica.OnResize(Sender: TObject);
var half:Integer;
begin
    if last then exit;
    hist.width := width - hist.left * 3;
    bd.width := hist.width;
    half := ac.height div 2;
    bd.top := hist.top + hist.height + half;
    ac.top := bd.top + bd.height + half;
    fraction.top := ac.top;
    Label1.top := ac.top + ac.height - label1.height;
    {Label2.top := Label1.top + Label1.height + label1.height div 2;}
    HelpButton.top := ac.top + ac.height + half;
    taibun.top := Helpbutton.top;
    Label2.top := taibun.top;
    ClientHeight := taibun.top + taibun.height + half div 2;
    bd.text := hist.text + ';';
end;

{ ------------
  ]
  ------------}
procedure Tfyurica.eva(Sender: TObject);
begin
    if hist.sellength > 0 then begin
       hist.seltext := calc(hist.seltext);
    end;
end;

{ --------------------------
  ]ccdpvZ
  --------------------------}
function Tfyurica.calc(shiki:string):string;
var s:stringStream;
    e:TloRational;
begin
    e := TloRational.Create(0,1);
    result := '';
    try
        s := StringStream.fromString(shiki+';');
        try
           Expression(e, s);
           result := e.asstring;
        except on e:Exception do begin
           result := e.Message ;
           s.free;
           end;
        else
           s.free;
        end;
    finally
        e.free;
    end;
end;

{ --------------
  ccdp
  --------------}
function Tfyurica.frac(shiki:string):string;
var s:stringStream;
    e:TloRational;
begin
    e := TloRational.Create(0,1);
    result := '';
    try
        s := StringStream.fromString(shiki+';');
        try
           Expression(e, s);
           result := e.asFraction;
        except on e:Exception do begin
           result := e.Message ;
           s.free;
           end;
        else
           s.free;
        end;
    finally
        e.free;
    end;
end;

{ --------------
  ccdpѕ
  --------------}
function Tfyurica.tai(shiki:string):string;
var s:stringStream;
    e:TloRational;
begin
    e := TloRational.Create(0,1);
    result := '';
    try
        s := StringStream.fromString(shiki+';');
        try
           Expression(e, s);
           result := e.asTaibun;
        except on e:Exception do begin
           result := e.Message ;
           s.free;
           end;
        else
           s.free;
        end;
    finally
        e.free;
    end;
end;

{ --------------
  ccdpC
  --------------}
procedure Tfyurica.maceval(Sender: TObject; Msg: TStrings);
begin
    if msg.strings[0] = 'calc' then begin
       yuri.text := calc(yuri.text);
    end else if msg.strings[0] = 'frac' then begin
       yuri.text := frac(yuri.text);
    end else if msg.strings[0] = 'tai' then begin
       yuri.text := tai(yuri.text);
    end;
end;

procedure Tfyurica.Exit1Click(Sender: TObject);
begin
close;
end;

{ --------------
  ̂Q
  --------------}
procedure Tfyurica.OnShow(Sender: TObject);
begin
    if first then begin
      first := false;
    end else begin
      exit;
    end;
    iniRead;
    if ParamCount > 0 then begin
       FileCalc;
    end;

end;

{ ----------------------
  fobOpt@CvZ
  ----------------------}
procedure Tfyurica.FileCalc;
var
  FIN:TextFile;
  FOUT:TextFile;
  l:string;
  k:string;
begin
  AssignFile(FIN, ParamStr(1));
  AssignFile(FOUT, ParamStr(2));
  Reset(FIN);
  ReWrite(FOUT);
  try
    while not seekEOF(FIN) do begin
      Readln(FIN, l);
      if l[1] = '#' then begin
         writeln(FOUT, l);
      end else begin
         k := calc(l);
         writeln(FOUT, format('%s = %s',[l,k]));
      end;
    end;
  finally
    CloseFile(FIN);
    CloseFile(FOUT);
  end;
end;
{--------------------
 t@Co
 --------------------}
procedure Tfyurica.IniWrite;
var
     ini:TiniFile;
     fn:string;
     i,p:integer;
begin
     if WindowState <> wsNormal then exit;
     fn := Application.exeName;
     p := 0;
     for i := 1 to length(fn) do begin
         if fn[i] = '.' then begin
             p := i;
         end;
     end;
     if p <> 0 then begin
         fn := copy(fn, 0, p);
     end;
     fn := fn + 'ini';
     ini := TiniFile.Create(fn);
     ini.WriteInteger('FORM','top',top);
     ini.WriteInteger('FORM','left',left);
     ini.WriteInteger('FORM','width',width);
     ini.WriteInteger('FORM','height',height);
     ini.WriteBool('FORM','junkan',J1.checked);
     ini.WriteString('Font','name', hist.font.name);
     ini.WriteInteger('Font','size',hist.font.size);
     ini.WriteInteger('Font','color',hist.font.color);
     ini.free;
end;
{----------------
 t@CǍ
 ----------------}
procedure Tfyurica.IniRead;
var
     ini:TiniFile;
     fn:string;
     i,p:integer;
begin
     fn := Application.exeName;
     p := 0;
     for i := 1 to length(fn) do begin
         if fn[i] = '.' then begin
             p := i;
         end;
     end;
     if p <> 0 then begin
         fn := copy(fn, 0, p);
     end;
     fn := fn + 'ini';
     ini := TiniFile.Create(fn);
     top := ini.readInteger('FORM','top',top);
     left := ini.readInteger('FORM','left',left);
     width := ini.readInteger('FORM','width',width);
     height := ini.readInteger('FORM','height',height);
     J1.checked := ini.readBool('FORM','junkan',J1.checked);
     hist.font.name := ini.ReadString('Font','name', hist.font.name);
     hist.font.size := ini.ReadInteger('Font','size',hist.font.size);
     hist.font.color := ini.ReadInteger('Font','color',hist.font.color);
     bd.canvas.Font.assign(hist.font);
     ini.free;
     bd.refresh;
     {onresize(self);}
end;

{-------------------
  ύX\ɔf
 -------------------}
procedure Tfyurica.histChange(Sender: TObject);
begin
     bd.text := hist.text+';';
end;

{-------------------
  ؂
 -------------------}
procedure Tfyurica.KT1Click(Sender: TObject);
var cb:TClipBoard;
begin
    cb := ClipBoard;
    cb.setTextBuf(PChar(hist.SelText));
    hist.Seltext := '';
end;

{-------------------
  Rs[
 -------------------}
procedure Tfyurica.KC1Click(Sender: TObject);
var cb:TClipBoard;
begin
    cb := ClipBoard;
    cb.setTextBuf(PChar(hist.SelText));
end;

{-------------------
  \t
 -------------------}
procedure Tfyurica.KP1Click(Sender: TObject);
var cb:TClipBoard;
    bf:PChar;
begin
    GetMem(bf, 1024);
    cb := ClipBoard;
    cb.getTextBuf(bf,1000);
    hist.seltext := StrPas(bf);
    FreeMem(bf);
end;

{-------------------
  tHgύX
 -------------------}
procedure Tfyurica.N4Click(Sender: TObject);
begin
     FontDialog1.font.assign(hist.font);
     if FontDialog1.execute then begin
        hist.font.assign(fontdialog1.font);
        bd.canvas.font.assign(fontdialog1.font);
     end;
     bd.refresh;
     OnResize(Sender);
end;

{-------------------
  z\ύX
 -------------------}
procedure Tfyurica.J1Click(Sender: TObject);
begin
    J1.Checked := not J1.Checked;
end;

{------------
  ׂđI
 ------------}
procedure Tfyurica.SelectAll1Click(Sender: TObject);
begin
    hist.Selstart := 0;
    hist.Sellength := length(hist.text);
end;

end.
