unit tabai;

interface
uses
    SysUtils, Stream, Forms;
const {TSeisuMaxLen       = 501;}
      TSeisuMaxLen       =1000000000;
      {TSeisuBase	 = 100;} (* 100 i@ *)
      TSeisuBase	 = 10000; (* 10000 i@ *)
      TSeisuBaseMinusOne = 9999;  (* Base - 1 *)

type
    TSeisuException = class(Exception);
    hikaku = (gt, eq, lt);
    Digit           = 0..TSeisuBaseMinusOne; (* e̐ *)
    hai = array[0..TSeisuMaxLen] of Digit;
    phai = ^hai;
    TSeisu = class(TObject)
    private
    public
      Len : 0..TSeisuMaxLen;
      Size : 0..TSeisuMaxLen;
      {Num : array [0..TSeisuMaxLen] of Digit;}
      Num : phai;
      function asString:string;
      function asDouble:double;
      function isZero:boolean;
      function isEqual(n:Digit):boolean;
      procedure readfromStream(s:StringStream);
      procedure LongWrite(var f:TextFile);
      procedure Add(B:TSeisu);
      procedure Inc(N: Digit);
      procedure ShortMul(N: Digit);
      procedure Mul(B: TSeisu);
      procedure ruijo(src:TSeisu);
      procedure Copy(src:TSeisu);
      procedure setInt(src:LongInt);
      procedure expand;
      procedure expandto(s:LongInt);
      constructor fromStringStream(s:StringStream);
      constructor fromInt(X:LongInt);
      constructor Create;
      destructor Destroy;override;
    end;
procedure LongAdd(X, A, B: TSeisu);
function LongComparison(A, B : TSeisu):hikaku;
procedure LongSub(X, A, B : TSeisu);
procedure LongMul(X, A, B : TSeisu);
procedure LongMulo(X, A, B : TSeisu);
procedure ShortDiv(Q, A : TSeisu;
                   N    : Digit;
               var R    : Digit);
procedure LongDiv(Q, A, B, R : TSeisu);
procedure computeE;
procedure computePi;
procedure gcd(g:TSeisu; a:TSeisu; b:TSeisu);

implementation
const
   {Base		= 100;} (* 100 i@ *)
   Base		= 10000; (* 10000 i@ *)
   BaseMinusOne	= 9999;  (* Base - 1 *)
   Base2	= 100000000; (* Base * Base *)
   MaxLen	= 1000000000; (* Base i@ł̍ő包 *)

procedure gcd(g:TSeisu; a:TSeisu; b:TSeisu);
var
   t, x, y, q: TSeisu;
begin
   t := TSeisu.Create;
   x := TSeisu.Create;
   y := TSeisu.Create;
   q := TSeisu.Create;
   try
     x.copy(a);
     y.copy(b);
     while y.Len > 0 do
     begin
          Longdiv(q, x, y, t);{t := x mod y}
          x.copy(y);
          y.copy(t);
     end;
     g.copy(x);
   finally
     t.free;
     x.free;
     y.free;
     q.free;
   end;
end;
{-------------------
 [
 ------------------}
function TSeisu.isZero:boolean;
begin
   isZero := (Len = 0);
end;

function TSeisu.isEqual(n:Digit):boolean;
begin
   isEqual := ((Len = 1) and (Num[1] = n));
end;

{-------------------
 {̏óij
 ------------------}
function TSeisu.asString:string;
var I,J,T : LongInt;
begin
  if Len > 0 then begin
      result := format('%d', [Num[Len]]);
      for I := Len -1 downto 1 do begin
         J := Base div 10;
         T := Num[I];
         while J > 0 do begin
             result := result + format('%d', [T div J]);
             T := T mod J;
             J := J div 10;
         end;
      end;
  end else result := format('%d', [0]);
end;


{-------------------
 {̏ói_j
 ------------------}
function TSeisu.asDouble:double;
var I : LongInt;
begin
  if Len > 0 then begin
      result := Num[Len];
      for I := Len -1 downto 1 do
         result := result * Base + Num[I];
  end else result := 0;
end;

{-------------------
 {̏óit@Cj
 ------------------}
procedure TSeisu.LongWrite(var f:TextFile);
var I,J,T : LongInt;
begin
  if Len > 0 then begin
      write(f, Num[Len]);
      for I := Len -1 downto 1 do begin
         J := Base div 10;
         T := Num[I];
         while J > 0 do begin
             write(f, T div J:1);
             T := T mod J;
             J := J div 10;
         end;
      end;
      for I := Len -1 downto 1 do
  end else write(f, 0);
end;

{----------------------------
 {Z
 ----------------------------}
procedure TSeisu.Inc(N	: Digit);
var I,T	: LongInt;
begin
   if Len > 0 then begin
      T := Num[1] + N;
      I := 1;
      while ( I < Len) and (T >= Base) do begin
         T := T-Base;
         Num[I] := T;
         I := I + 1;
         T := Num[I] + 1;
      end;
      if T < Base then begin
         Num[I] := T;
      end else if I < MaxLen then begin
         Num[I] := T - Base;
         Len := I + 1;
         expandto(Len);
         Num[Len] := 1;
      end else begin
         raise TSeisuException.Create('ӂꂪN܂');
      end
   end else if N > 0 then begin
      Len := 1;
      Num[1] := N
   end
end;

{------------------------
 {ǂ̑Z
 ------------------------}
procedure TSeisu.Add(B:TSeisu);
begin
    LongAdd(Self, Self, B);
end;
procedure LongAdd(X, A, B: TSeisu);

procedure AuxAdd(var X, A, B : TSeisu);
var I, T : LongInt;
begin
   T:=0;
   X.Expandto(A.Len);{oOC 2000/07/26}
   { ̌̂ }
   for I := 1 to B.Len do begin
      T := A.Num[I] + B.Num[I] +T;
      if T < Base then begin
	 X.Num[I] := T;
	 T := 0;
      end else begin
	 X.Num[I] := T - Base;
	 T := 1;
      end
   end;
   I := B.Len +1;
   { 傫̌̂ }
   while ( I <= A.Len ) and (T <> 0) do begin
      T := A.Num[I] + T;
      if T < Base then begin
	 X.Num[I] := T;
	 T := 0;
      end else begin
	 X.Num[I] := T - Base;
	 T := 1;
      end;
      I := I + 1;
   end;
   for I := I to A.Len do begin
      X.Num[I] := A.Num[I];
   end;
   if T = 0 then begin
       X.Len := A.Len;
   end else if A.Len < MaxLen then begin
      X.Len := A.Len +1;
      X.Expandto(X.Len);
      X.Num[X.Len] := 1
   end else begin
       raise TSeisuException.Create('LongAdd ŌӂꂪN܂');
   end;
end;

begin { Long Add }
   if A.Len >= B.Len then begin
     AuxAdd(X, A, B);
   end else begin
     AuxAdd(X, B, A);
   end;
end;
{----------------------
 {ǂ̔r
 ----------------------}

function LongComparison(A, B : TSeisu):hikaku;
var I : LongInt;
begin
   LongComparison := eq;
   if A.Len > B.Len then LongComparison := gt
   else if A.Len < B.Len then LongComparison := lt
   else begin
      I := A.Len;
      A.Num[0] := 0;
      B.Num[0] := 1;
      while A.Num[I] = B.Num[I] do I := I -1;
      if I=0 then LongComparison := eq
      else if A.Num[I] > B.Num[I] then LongComparison := gt
      else if A.Num[I] < B.Num[I] then LongComparison := lt;
   end
end; { Comparison }

{------------------------
 {ǂ̈Z
 ------------------------}
procedure LongSub(X, A, B : TSeisu);
var I, T : LongInt;
begin
   if A.Len >= B.Len then begin
      X.expandto(A.Len);
      T := 0;
      for I := 1 to B.Len do begin
	 T := A.Num[I] - B.Num[I] - T;
	 if T >= 0 then begin
	    X.Num[I] := T;
	    T := 0;
	 end else begin
	    X.Num[I] := T + Base;
	    T := 1;
	 end
      end;
      I := B.Len + 1;
      while ( I <= A.Len ) and ( T <> 0 ) do begin
	 T := A.Num[I] -T;
	 if T >= 0 then begin
	    X.Num[I] := T;
	    T := 0;
	 end else begin
	    X.Num[I] := T + Base;
	    T := 1
	 end;
	 I := I +1;
      end;
      for I := I to A.Len do X.Num[I] := A.Num[I];
      X.Len := A.Len;
      X.Num[0] := 1;
      while X.Num[X.Len]  = 0 do X.Len := X.Len -1;
   end else T := 1;
   if T <> 0 then begin
       raise TSeisuException.Create('LongSub ŌʂɂȂ܂');
   end;
end; { LongSub }

{----------------------------
 {ƒZ̊|Z
 ----------------------------}
procedure TSeisu.ShortMul(N: Digit);
var I, T : LongInt;
begin
   if N > 0 then begin
      T := 0;
      for I := 1 to Len do begin
	 T := Num[I] * N + T;
	 Num[I] := T mod Base;
	 T := T div Base;
      end;
      if T <> 0 then begin
        if Len = MaxLen then begin
           raise TSeisuException.Create('Shortmul ŌӂꂪN܂');
        end else begin
	   Len := Len +1;
           expandto(Len);
	   Num[Len] := T;
        end;
      end;
   end else begin
     Len := 0;
   end;
end; { ShortMul }

{------------------------
 {ǂ̊|Z
 ------------------------}
procedure TSeisu.Mul(B:TSeisu);
var T:TSeisu;
begin
  T := TSeisu.fromInt(0);
  try
    LongMulo(T, Self, B);
    copy(T);
  finally
    T.free;
  end;
end;
{ X := A * B  }
procedure longMul(X, A, B: TSeisu);
begin
  X.setInt(0);
  LongMulo(X, A, B);
end;
{ X := X + A * B  }
procedure LongMulo(X, A, B: TSeisu);
var I,J,L,T,U : LongInt;
begin
   if (A.Len <> 0) and (B.Len <> 0) then begin
      if A.Len + B.Len > X.Len then begin
	 L := A.Len + B.Len;
         X.expandto(L);
      end else begin
	 L := X.Len +1;
      end;
      if L < MaxLen then begin
	 for I := X.Len +1 to L do X.Num[I] := 0;
	 for J := 1 to B.Len do begin
            Application.ProcessMessages;
	    U := B.Num[J];
	    if U <> 0 then begin
	       T := 0;
	       for I := J to A.Len + J -1 do begin
		  T := X.Num[I] + A.Num[I - J +1] * U + T;
		  X.Num[I] := T mod Base;
		  T := T div Base;
	       end;
	       I := A.Len + J;
	       T := X.Num[I] + T;
	       while T >= Base do begin
		  X.Num[I] := T - Base;
		  I := I +1;
		  T := X.Num[I] +1;
	       end;
	       X.Num[I] := T;
	    end;
	 end;
	 if X.Num[L] = 0 then begin
	    X.Len := L -1;
	 end else begin
	    X.Len := L;
	 end;
      end else begin
	 raise TSeisuException.Create('LongMul ŌӂꂪN܂');
      end;
   end;
end; { LongMul }

{--------
  ݏ
 --------}
procedure TSeisu.ruijo(src:TSeisu);
var
   p:TSeisu;
   x:TSeisu;
   n:TSeisu;
   amari:TSeisu;
   con2:TSeisu;
begin
     p := TSeisu.fromInt(1);
     x := TSeisu.fromInt(1);
     n := TSeisu.Create;
     amari  := TSeisu.Create;
     con2 := TSeisu.fromInt(2);
     try
         x.copy(self);
         n.copy(src);
         while not n.isZero do begin
             Application.ProcessMessages;
             LongDiv(n, n, con2, amari);
             if not amari.isZero then begin
                 p.Mul(x);
             end;
             if n.isZero then break;{ŔfȂƌӂꂪNB}
             x.Mul(x);
         end;
         self.copy(p);
     finally
         p.free;
         x.free;
         n.free;
         amari.free;
         con2.free;
     end;
end;

{------------------------------
 {̒Zł̊Z
 ------------------------------}
{ Q := A div N ; R := A mod N}
procedure ShortDiv(Q, A : TSeisu;
	           N    : Digit;
               var R    : Digit);
var I, T : LongInt;
begin
   T := 0;
   for I := A.Len downto 1 do begin
      T := T * Base + A.Num[I];
      Q.Num[I] := T div N;
      T := T mod N;
   end;
   R := T;
   if Q.Num[A.Len] = 0 then begin
      Q.Len := A.Len -1;
      Q.Expandto(Q.Len);
   end else begin
      Q.Len := A.Len;
      Q.Expandto(Q.Len);
   end;
end;

{------------------------
 {ǂ̊Z
 ------------------------}
{ Q := A div B ; R := A mod B }
procedure LongDiv(Q, A, B, R : TSeisu);
var I,J,D,T : LongInt;
   C	    : TSeisu;
   Q1,R1    : Digit;

function tooLarge:boolean;
var T : Real;
begin
   T := R.Num[J] * Base + R.Num[J -1] - Q1 * C.Num[B.Len];
   if T >= Base then begin
      TooLarge := false;
   end else begin
      TooLarge := C.Num[B.Len -1] * Q1 > T * Base + R.Num[J -2];
   end;
end;

begin
   C := TSeisu.Create;
   Q.expandto(A.Len-B.Len+1);
   try
   if B.Len = 0 then begin
       raise TSeisuException.Create('0 ł͊܂');
   end else if A.Len < B.Len then begin
      Q.Len := 0;
      R.copy(A);
   end else if B.Len = 1 then begin
      ShortDiv(Q, A, B.Num[1], R.Num[1]);
      if R.Num[1] > 0 then begin
	 R.Len := 1;
      end else begin
	 R.Len := 0;
      end;
   end else if A.Len = MaxLen then begin
      raise TSeisuException.Create('폜傫߂܂');
   end else begin
      { 鐔 B ̐擪ɑ傫Ȑ悤ɂ }
      D := Base div (B.Num[B.Len] +1);
      T := 0;
      { 鐔 D { }
      R.Expandto(A.len + 1);
      for I := 1 to A.Len do begin
	 T := A.Num[I] * D + T;
	 R.Num[I] := T mod Base;
	 T := T div Base;
      end;
      R.Num[A.Len +1] := T;
      T := 0;
      { 鐔 D { }
      C.Expandto(B.len);
      for I := 1 to B.Len do begin
	 T := B.Num[I] * D +T;
	 C.Num[I] := T mod Base;
	 T := T div Base;
      end;
      for J := A.Len +1 downto B.Len +1 do begin
	 if R.Num[J] = C.Num[B.Len] then begin
	    Q1 := Base -1;
	 end else begin
	    Q1 := (R.Num[J] * Base + R.Num[J -1]) div C.Num[B.Len];
	 end;
	 while TooLarge do Q1 := Q1 -1;
	 T := 0;
	 for I := J - B.Len to J -1 do begin
	    T := Base2 - C.Num[I -J + B.Len +1] * Q1 + R.Num[I] + T;
	    R.Num[I] := T mod Base;
	    T := T div Base -Base;
	 end;
	 if R.Num[J] + T <> 0 then begin
	    T := 0;
	    for i := J - B.Len to J -1 do begin
	       T := R.Num[I] + C.Num[I -J + B.Len +1] + T;
	       if T < Base then begin
		  R.Num[I] := T;
		  T := 0;
	       end else begin
		  R.Num[I] := T - Base;
		  T := 1;
	       end;
	    end;
	    Q1 := Q1 -1;
	 end;
	 Q.Num[J - B.Len] := Q1;
      end;
      Q.Len := A.Len - B.Len +1;
      if Q.Num[Q.Len] = 0 then Q.Len := Q.Len -1;
      R.Len := B.Len;
      R.Num[0] := 1;
      while R.Num[R.Len] = 0 do R.Len := R.Len -1;
      ShortDiv(R, R, D, R1);
   end;
   finally
      C.free;
   end;
end; { LongDiv }

{----------------
 {ǂ
 ----------------}
constructor TSeisu.fromStringStream(s:StringStream);
var c  : char;
begin
   Create;
   repeat c := s.readChar until C in ['0' .. '9'];
   Len := 0;
   repeat
      ShortMul(10);
      Inc(ord(C) - ord('0'));
      C := s.readChar
   until not( C in ['0' .. '9']);
   s.unreadChar;
end; { LongRead }

{----------------
 
 ----------------}
constructor TSeisu.Create;
var i:LongInt;
begin
   inherited Create;
   reAllocMem(Num,sizeOf(Num[0])*(10+1));
   size := 10;
   Len := 0;
   for i := 0 to size do begin
      num[i] := 0;
   end;
end; { LongRead }

{----------------
 I
 ----------------}
destructor TSeisu.Destroy;
begin
   reAllocMem(Num,0);
   inherited Destroy;
end; { LongRead }

{----------------
 {ǂ
 ----------------}
procedure TSeisu.readfromStream(s:StringStream);
var c  : char;
begin
   repeat c := s.readChar until C in ['0' .. '9'];
   Len := 0;
   repeat
      ShortMul(10);
      Inc(ord(C) - ord('0'));
      C := s.readChar
   until not( C in ['0' .. '9']);
   s.unreadChar;
end; { LongRead }

{----------------
 z̊g
 ----------------}
procedure TSeisu.expand;
begin
   reAllocMem(Num,sizeOf(Num[0])*(size+100+1));
   size := size + 100;
end; 

{----------------
 z̊g
 ----------------}
procedure TSeisu.expandto(s:LongInt);
var e:LongInt;
begin
   if size >= s then exit;
   e := ((s div 100)+1)*100;
   reAllocMem(Num,sizeOf(Num[0])*(e+1));
   size := e;
end;

{----------------------------
 ʏ̐𑽔{ɒ
 ----------------------------}
constructor TSeisu.fromInt(X:LongInt);
begin
   Create;
   if X < 0 then begin
       raise TSeisuException.Create('͈̐܂');
   end else begin
      Len := 0;
      while X <> 0 do begin
	 Len := Len +1;
         expandto(Len);
	 Num[Len] := X mod Base;
	 X := X div Base;
      end;
   end;
end; { LongAssign }
{------------------------
  Copy
  -----------------------}
procedure TSeisu.Copy(src:TSeisu);
var I:LongInt;
begin
    Len := src.Len;
    expandto(Len);
    for I := 0 to Len do begin
        Num[I] := src.Num[I];
    end;
end;

{-----------------------
  ̃Zbg
 -----------------------}
procedure TSeisu.setInt(src:LongInt);
begin
   if src < 0 then begin
       raise TSeisuException.Create('͈̐܂');
   end else begin
      Len := 0;
      while src <> 0 do begin
	 Len := Len +1;
         expandto(Len);
	 Num[Len] := src mod Base;
	 src := src div Base;
      end;
   end;
end;

{-----------------------
 Rΐ̒ e ߂
 -----------------------}
procedure ComputeE;
const N	= 500;
var I	      : LongInt;
   E, K, T, R : TSeisu;
   f:TextFile;
begin
   AssignFile(f, 'e.txt');
   Rewrite(f);
   E := TSeisu.Create;
   K := TSeisu.fromInt(1);
   T := TSeisu.Create;
   R := TSeisu.Create;
   try
       E.Len := N +1;
       E.Expandto(E.len);
       E.Num[E.Len] := 1;
       for I := 1 to N do E.Num[I] := 0;
       T.Copy(E);
       repeat
          LongAdd(E, E, T);
          K.Inc(1);
          LongDiv(T, T, K, R);
       until T.Len = 0;
       {for debug}
       writeln(f, e.len:1);
       writeln(f, 'e * ', Base :1, ' ^ ', N:1, ' = ');
       E.LongWrite(f);
       writeln(f);
   finally
   CloseFile(f);
   E.free;
   K.free;
   T.free;
   R.free;
   end;
end;
{-----------------------
 ~  ߂
 -----------------------}
procedure ComputePi;
const N	= 500;
var I	      : LongInt;
   Pi, K, T, U, N239, N239Sq, R: TSeisu;
   R1: Digit;
   f:TextFile;
begin
   AssignFile(f, 'pi.txt');
   Rewrite(f);
   Pi := TSeisu.fromInt(0);
   K := TSeisu.fromInt(1);
   T := TSeisu.Create;
   U := TSeisu.Create;
   N239 := TSeisu.fromInt(239);
   N239Sq := TSeisu.fromInt(239*239);
   R := TSeisu.Create;
   try
       T.Len := N +1;
       T.Expandto(T.len);
       T.Num[T.Len] := 16;
       for I := 1 to N do T.Num[I] := 0;
       ShortDiv(T, T, 5, R1);
       U.Copy(T);
       repeat
          LongAdd(Pi, Pi, U);
          ShortDiv(T, T, 25, R1);
          K.Inc(2);
          LongDiv(U, T, K, R);
          LongSub(Pi, Pi, U);
          ShortDiv(T, T, 25, R1);
          K.Inc(2);
          LongDiv(U, T, K, R);
       until U.Len = 0;
       T.Len := N +1;
       T.Expandto(T.len);
       T.Num[T.Len] := 4;
       for I := 1 to N do T.Num[I] := 0;
       LongDiv(T, T, N239, R);
       K.SetInt(1);
       U.Copy(T);
       repeat
          LongSub(Pi, Pi, U);
          LongDiv(T, T, N239Sq, R);
          K.Inc(2);
          LongDiv(U, T, K, R);
          LongAdd(Pi, Pi, U);
          LongDiv(T, T, N239Sq, R);
          K.Inc(2);
          LongDiv(U, T, K, R);
       until U.Len = 0;
       {for debug}
       writeln(f, Pi.len:1);
       writeln(f, 'Pi * ', Base :1, ' ^ ', N:1, ' = ');
       Pi.LongWrite(f);
       writeln(f);
   finally
   CloseFile(f);
   Pi.free;
   K.free;
   T.free;
   U.free;
   N239.free;
   N239Sq.free;
   R.free;
   end;
end;

end.
