unit Stream;

interface
uses SysUtils;
type
    TStreamException = class(Exception);
    TInputStream = class(TObject)
    public
      function readChar:Char;virtual;
      function peepChar:Char;virtual;
      function iseof:Boolean;virtual;
      procedure unreadChar;virtual;
    end;
    TOutputStream = class(TObject)
    public
      procedure putChar(c:Char);virtual;
    end;
    StringStream = class(TInputStream)
    private
      s:string;
      i:integer;
    public
      function readChar:Char;override;
      function peepChar:Char;override;
      function iseof:Boolean;override;
      procedure unreadChar;override;
      constructor fromString(org:string);
    end;
    TOutputFileStream = class(TOutputStream)
    private
      f:TextFile;
      name:string;
    public
      procedure putChar(C:Char);override;
      constructor Create(s:string);
      destructor Destroy;override;
    end;

implementation
function TInputStream.readChar:Char;
begin
    Result := 'x';
end;
function TInputStream.peepChar:Char;
begin
    Result := readChar;
    unreadChar;
end;
function TInputStream.iseof:Boolean;
begin
    Result := true;
end;
procedure TInputStream.unreadChar;
begin
     ;
end;
procedure TOutputStream.putChar(C:Char);
begin
     ;
end;
constructor StringStream.fromString(org:string);
begin
    s := copy(org, 1, length(org));
    i := 1;
end;

function StringStream.readChar:Char;
begin
    if i <= length(s) then begin
        Result := s[i];
        i := i+1;
    end else begin
        raise TStreamException.Create('end of stream');
    end;
end;

function StringStream.peepChar:Char;
begin
    if i <= length(s) then begin
        Result := s[i];
    end else begin
        raise TStreamException.Create('end of stream');
    end;
end;

procedure StringStream.unreadChar;
begin
    if i > 1 then begin
        i := i -1;
    end else begin
        raise TStreamException.Create('begining of stream');
    end;
end;

function StringStream.iseof:Boolean;
begin
    Result := (i > length(s));
end;

constructor TOutputFileStream.Create(s:string);
begin
  AssignFile(f, s);
  name := s;
  Reset(f);
end;

destructor TOutputFileStream.Destroy;
begin
  CloseFile(f);
end;

procedure TOutputFileStream.putChar(C:Char);
begin
  write(f, C);
end;
end.
