unit lrat;

{{L}
interface
uses
    SysUtils, Stream, tabai, forms;
type
    TLoRationalException = class(Exception);
    TLoRational = class(TObject)
    private
      bunshi:TSeisu;
      bunbo:TSeisu;
    public
      sign:Integer;
      class procedure setDefaultFractMaxDigits(max:word);
      class function getDefaultFtactMaxDigits:Word;
      procedure tasu(src:TLoRational);
      procedure natutasu(src:TLoRational);
      procedure hiku(src:TLoRational);
      procedure natuhiku(src:TLoRational);
      procedure kakeru(src:TLoRational);
      procedure waru(src:TLoRational);
      procedure ruijo(src:TLoRational);
      procedure ruijo2(src:TLoRational);
      procedure gyakusu;
      procedure clear;
      procedure copy(src:TLoRational);
      function asString:String;
      function asTaibun:String;
      function asFraction:String;
      function asFraction2(circle:boolean):string;overload;
      function asFraction2(circle:boolean;fractMaxDigits:Word):string;overload;
      {function asFraction2:String;}
      function asFractCircle(x,y:Integer):string;
      function iszero:Boolean;
      procedure yakubun;
      constructor Create(ko:LongInt; oya:LongInt);
      destructor Destroy;override;
      procedure readFromStream(s:StringStream);
      procedure tubun(a,b:TLoRational);
    end;
implementation
{--------------------
  ftHg_\Lő包iNXϐHj
 --------------------}
var DefaultFractMaxDigits:Word = 100;
{--------------------
  ftHg\Lő包ݒ
 --------------------}
class procedure TLoRational.setDefaultFractMaxDigits(max:word);
begin
    DefaultFractMaxDigits := max;
end;
{--------------------
  ftHg_\Lő包擾
 --------------------}
class function TLoRational.getDefaultFtactMaxDigits:Word;
begin
    Result := DefaultFractMaxDigits;
end;
{--------------------
  쐬iqwj
 --------------------}
constructor TLoRational.Create(ko:LongInt; oya:LongInt);
begin
     if oya = 0 then raise TLoRationalException.Create('0Ŋ낤Ƃ');
     sign := ko * oya;
     if ko = 0 then sign := 1
     else begin
         sign := sign div abs(sign);
     end;
     bunshi := TSeisu.fromInt(abs(ko));
     bunbo := TSeisu.fromInt(abs(oya));
     yakubun;
end;
destructor TLoRational.Destroy;
begin
    bunshi.free;
    bunbo.free;
    inherited Destroy;
end;

{---------
  Rs[
 ---------}
procedure TLoRational.Copy(src:TLoRational);
begin
     bunshi.copy(src.bunshi);
     bunbo.copy(src.bunbo);
     sign := src.sign;
end;

{-------------------------
  Xg[̓ǂݍ
 -------------------------}
procedure TLoRational.readFromStream(s:StringStream);
  var C: char;
      T:TLoRational;
      Seisubu:TLoRational;
begin
    sign := 1;
    bunshi.setInt(0);
    bunbo.setInt(1);
    if not (s.peepChar in ['+','-','0'..'9']) then begin
        raise TLoRationalException.Create('Ȃ');
    end;
    if s.peepChar in ['+','-'] then begin
        if s.readChar = '-' then sign := -1;
    end;
    bunshi.readfromStream(s);
    try
        C := s.readChar;
        if (C = '/') and (s.peepChar in ['0'..'9']) then begin
            bunbo.readfromStream(s);
        end else if (C='.') and (s.peepChar in ['0'..'9','[']) then begin
            C := s.readChar;
            while C in ['0'..'9'] do begin
                bunbo.ShortMul(10);
                bunshi.ShortMul(10);
                bunshi.Inc(ord(C) - ord('0'));
                C := s.readChar;
            end;
            {zē}
            if C = '[' then begin
                T := TLoRational.Create(0,1);
                Seisubu := TLoRational.Create(0,1);
                Seisubu.bunshi.copy(bunshi);
                Seisubu.bunbo.copy(bunbo);
                bunshi.setInt(0);
                try
                   C := s.readChar;
                   while C in ['0'..'9'] do begin
                     {bunbo.ShortMul(10);}
                     bunshi.ShortMul(10);
                     bunshi.Inc(ord(C) - ord('0'));
                     T.bunshi.ShortMul(10);
                     T.bunshi.Inc(9);
                     C := s.readChar;
                   end;
                   waru(T);
                   s.readChar;{']'̓ǂݔ΂}
                   tasu(Seisubu);
                finally
                    T.free;
                    Seisubu.free;
                end;
            end;
            s.unreadChar;
        end else begin
            bunbo.setInt(1);
            s.unreadChar;
        end;
    except on TStreamException do ;
    end;
    if bunbo.IsZero then raise TLoRationalException.Create('0Ŋ낤Ƃ');
    yakubun;
end;

{-----------
  \L
 -----------}
function TLoRational.asString:string;
var
   s:string;
begin
     if sign < 0 then s := '-' else s:='';
     if (bunbo.len =1) and (bunbo.num[1]=1) then begin
         result := s + bunshi.asString;
     end else begin
         result := s + bunshi.asString + '/' + bunbo.asString;
     end;
end;

{-----------
  ѕ\L
 -----------}
function TLoRational.asTaibun:string;
var tai, bun : TSeisu;
    k1,k2 : String;
begin
     if sign > 0 then begin
         Result := '';
         k1:='';
         k2:='';
     end else begin
         Result := '-';
         k1:='(';
         k2:=')';
     end;
     if bunbo.isequal(1) then begin
         Result := Result + bunshi.asString;
     end else if LongComparison(bunshi, bunbo) = lt then begin
         result := Result + bunshi.asString + '/' +
                   bunbo.asString;
     end else begin
         tai := TSeisu.Create;
         bun := TSeisu.Create;
         try
             LongDiv(tai, bunshi, bunbo, bun);
             result := Result + k1 + tai.asString +
                       '+' +
                       bun.asString + '/' +
                       bunbo.asString + k2;
         finally
             tai.free;
             bun.free;
         end;
     end;
end;

{---------
 \L
 ---------}
function TLoRational.asFraction:string;
var f:Double;
begin
     if sign > 0 then Result := '' else Result := '-';
     if bunbo.isZero then begin
         Result := 'ERROR' ;
     end else begin
         f := bunshi.asDouble / bunbo.asDouble;
         Result := Result+format('%g',[f]);
     end;
end;

{-----------
  \LQ
  (x)
 -----------}
function TLoRational.asFraction2(circle:boolean):string;
begin
    result := asFraction2(circle, DeFaultFractMaxDigits);
end;
{-----------
  \LQ
  (x)
 -----------}
function TLoRational.asFraction2(circle:boolean;fractMaxDigits:Word):string;
var sho, amari, shi : TSeisu;
begin
     if bunbo.isZero then begin
         Result := 'ERROR' ;
         exit;
     end;
     if bunshi.isZero then begin
         Result := '0';
         exit;
     end;
     if sign > 0 then Result := '' else Result := '-';
     if circle and (bunbo.len = 1) and (bunshi.len = 1) then begin
         Result := Result + asFractCircle(bunshi.num[1],bunbo.num[1]);
         exit;
     end;
     sho := TSeisu.Create;
     amari := TSeisu.Create;
     shi := TSeisu.Create;
     try
         LongDiv(sho, bunshi, bunbo, amari);
         if amari.isZero then begin
             Result := Result + sho.asString;
             exit;
         end else begin
             Result := Result + sho.asString + '.';
         end;
         while not amari.isZero do begin
             if length(Result) >= FractMaxDigits then begin
                 Result := Result + 'c';
                 break;
             end;
             amari.ShortMul(10);
             shi.copy(amari);
             LongDiv(sho, shi, bunbo, amari);
             Result := Result + sho.asString;
         end;
     finally
         shi.free;
         sho.free;
         amari.free;
     end;
end;

{-----------
  \LR
  (z)
 -----------}
function TLoRational.asFractCircle(x,y:Integer):string;
var sho, amari,i,j : LongInt;
    foundpoint : Integer;
    hantei : array [1..200] of record s:integer; a:Integer end;
begin
     if y= 0  then begin
         Result := 'ERROR' ;
         exit;
     end;
     for i:=1 to 200 do hantei[i].a := 0;
     if x * y > 0 then Result := '' else Result := '-';
     sho := x div y;
     amari := x mod y;
     Result := Result + format('%d',[sho]);
     if amari <> 0 then Result := Result + '.';
     {hantei[0].a := amari;}
     i := 0;
     foundPoint := 0;
     while amari <> 0 do begin
        if i >= 200 then break;
        amari := amari * 10;
        x := amari;
        sho := x div y;
        amari := x mod y;
        for j := 1 to i do begin
            if (hantei[j].a = amari)and(hantei[j].s = sho)
             then begin
                foundpoint := j;
                break;
            end;
        end;
        if foundpoint > 0 then begin
            break;
        end else begin
            i := i+1;
            hantei[i].a := amari;
            hantei[i].s := sho;
        end ;
     end;
     if foundpoint > 0 then begin
        for j := 1 to foundpoint-1 do begin
           Result := Result + format('%d',[hantei[j].s]);
        end;
        Result := Result + '[';
        for j := foundpoint to i do begin
           Result := Result + format('%d',[hantei[j].s]);
        end;
        Result := Result + ']';
     end else begin
        for j := 1 to i do begin
           Result := Result + format('%d',[hantei[j].s]);
        end;
     end;
end;
{---------
  @
 ---------}
procedure TLoRational.tasu(src:TLoRational);
begin
   if sign = src.sign then begin
      natutasu(src);
   end else begin
      natuhiku(src);
   end;
end;

{--------------
 @ij
 --------------}
procedure TLoRational.natutasu(src:TLoRational);
var
   wklr:TLoRational;
begin
     wklr := TLoRational.Create(0,1);
     try
       wklr.copy(src);
       tubun(self, wklr);
       bunshi.add(wklr.bunshi);
       yakubun;
     finally
       wklr.free;
     end;
end;
{---------
  ʕ
 ---------}
procedure TLoRational.tubun(a,b:TLoRational);
var
   wkgcd:TSeisu;
   wklcd:TSeisu;
   wktsei:TSeisu;
   wkbunbo:TSeisu;
begin
     wkgcd := TSeisu.Create;
     wklcd := TSeisu.Create;
     wktsei := TSeisu.Create;
     wkbunbo:= TSeisu.Create;
     try
       gcd(wkgcd, a.bunbo, b.bunbo);
       longdiv(wklcd, b.bunbo, wkgcd, wktsei);
       a.bunshi.mul(wklcd);
       Longmul(wkbunbo, a.bunbo, wklcd);
       longdiv(wklcd, a.bunbo, wkgcd, wktsei);
       b.bunshi.mul(wklcd);
       a.bunbo.copy(wkbunbo);
       b.bunbo.copy(wkbunbo);
     finally
       wkgcd.free;
       wklcd.free;
       wktsei.free;
       wkbunbo.free;
     end;
end;

{---------
  @
 ---------}
procedure TLoRational.hiku(src:TLoRational);
begin
     src.sign := -src.sign;
     try
         tasu(src);
     finally
         src.sign := -src.sign;
     end;
end;

{--------------
  @
 --------------}
procedure TLoRational.natuhiku(src:TLoRational);
var
   wklr:TLoRational;
begin
     wklr := TLoRational.Create(0,1);
     try
       wklr.copy(src);
       tubun(self, wklr);
       if Longcomparison(bunshi, wklr.bunshi) = lt then begin
           LongSub(bunshi, wklr.bunshi, bunshi);
           sign := -sign;
       end else begin
           LongSub(bunshi, bunshi, wklr.bunshi);
       end;
       yakubun;
     finally
       wklr.free;
     end;
end;

{--------
  NA
 --------}
procedure TLoRational.clear;
begin
     bunshi.setint(0);
     bunbo.setint(1);
     sign := 1;
end;

{--------
  @
 --------}
procedure TLoRational.kakeru(src:TLoRational);
var
   wkgcd1:TSeisu;
   wkgcd2:TSeisu;
   wktsei:TSeisu;
   amari:TSeisu;
begin
     wkgcd1 := TSeisu.Create;
     wkgcd2 := TSeisu.Create;
     wktsei := TSeisu.Create;
     amari  := TSeisu.Create;
     try
         sign := sign * src.sign;
         gcd(wkgcd1, bunshi, src.bunbo);
         gcd(wkgcd2, bunbo, src.bunshi);
         LongDiv(bunshi, bunshi, wkgcd1, amari);
         LongDiv(wktsei, src.bunshi, wkgcd2, amari);
         bunshi.Mul(wktsei);
         LongDiv(bunbo, bunbo, wkgcd2, amari);
         LongDiv(wktsei, src.bunbo, wkgcd1, amari);
         bunbo.Mul(wktsei);
     finally
         wkgcd1.free;
         wkgcd2.free;
         wktsei.free;
         amari.free;
     end;
     yakubun;
end;

{--------
  ݏ
 --------}
procedure TLoRational.ruijo(src:TLoRational);
var
   con2:TSeisu;
begin
     con2 := TSeisu.fromInt(2);
     if not (LongComparison(src.bunbo,con2)=lt) then begin
         raise TLoRationalException.Create('L悵悤Ƃ');
     end;
     try
         yakubun;
         bunbo.ruijo(src.bunshi);
         bunshi.ruijo(src.bunshi);
         if src.sign < 0 then begin
             self.gyakusu;
         end;
     finally
         con2.free;
     end;
end;

{--------
  ݏ
 --------}
procedure TLoRational.ruijo2(src:TLoRational);
var
   p:TLoRational;
   x:TLoRational;
   n:TSeisu;
   amari:TSeisu;
   con2:TSeisu;
begin
     p := TLoRational.Create(1,1);
     x := TLoRational.Create(1,1);
     n := TSeisu.Create;
     amari  := TSeisu.Create;
     con2 := TSeisu.fromInt(2);
     if not (LongComparison(src.bunbo,con2)=lt) then begin
         raise TLoRationalException.Create('L悵悤Ƃ');
     end;
     try
         x.copy(self);
         n.copy(src.bunshi);
         while not n.isZero do begin
             LongDiv(n, n, con2, amari);
             if not amari.isZero then begin
                 p.kakeru(x);
             end;
             if n.isZero then break;{ŔfȂƌӂꂪNB}
             x.kakeru(x);
         end;
         self.copy(p);
         if src.sign < 0 then begin
             self.gyakusu;
         end;
     finally
         p.free;
         x.free;
         n.free;
         amari.free;
         con2.free;
     end;
end;

{--------
  @
 --------}
procedure TLoRational.waru(src:TLoRational);
begin
     src.gyakusu;
     try
         kakeru(src);
     finally
         src.gyakusu;
     end;
end;

{----------
  [
 ----------}
function TLoRational.iszero:Boolean;
begin
     Result := bunshi.isZero;
end;

{--------
  t
 --------}
procedure TLoRational.gyakusu;
var
    l:TSeisu;
begin
     l := TSeisu.Create;
     try
         l.copy(bunshi);
         bunshi.copy(bunbo);
         bunbo.copy(l);
     finally
         l.free;
     end;
end;

{--------
  
 --------}
procedure TLoRational.yakubun;
var
   wkgcd:TSeisu;
   amari:TSeisu;
begin
   wkgcd := TSeisu.Create;
   amari := TSeisu.Create;
   try
       gcd(wkgcd, bunshi, bunbo);
       LongDiv(bunshi, bunshi, wkgcd, amari);
       LongDiv(bunbo, bunbo, wkgcd, amari);
   finally
       wkgcd.free;
       amari.free;
   end;
end;
end.
