unit Eval;

interface
    uses lrat, Stream, Winprocs, forms, SysUtils;
    type
        TEvalException = class(Exception);
  procedure Error;
  procedure Number(r:TloRational; s:StringStream);
  procedure Expression(r:TloRational; s:StringStream);
  procedure Term(r:TloRational; s:StringStream);
  procedure Factor(r:TloRational; s:StringStream);
  procedure Factor1(r:TloRational; s:StringStream);

implementation

procedure Error;
begin
  application.messagebox('ɕ@̊ԈႢ܂B','',0);
end;

{---------------------
  Number
----------------------}
procedure Number(r:TloRational; s:StringStream);
var C:Char;
begin
    try
        C := s.readChar;
        while C = ' ' do C := s.readChar;
        s.unreadChar;
    except on TStreamException do raise TEvalException.Create('Ȃ');
    end;
    r.readFromStream(s);
end;

{-----------------
  Factor
------------------}
procedure Factor(r:TloRational; s:StringStream);
var C:Char;
begin
    try
        C := s.readChar;
        while C = ' ' do C := s.readChar;
    except on TStreamException do raise TEvalException.Create('Ȃ');
    end;
    if C <> '(' then begin
        s.unreadChar;
        Number(r, s);
    end else begin
	Expression(r, s);
        try
            C := s.readChar;
            while C = ' ' do C := s.readChar;
	    if C = ')' then begin
                ;
            end else begin
                raise TEvalException.Create('JbRĂȂ');
            end;
        except on TStreamException do
           raise TEvalException.Create('JbRĂȂ');
        end;
    end;
end;
{--------------------
  Factor 1  P+-^
---------------------}
procedure Factor1(r:TloRational; s:StringStream);
var
      W: TloRational;
      C:Char;
      sign:Integer;
begin
    W := TloRational.Create(0,1);
    sign := 1;
    try
        try
            C := s.readChar;
            while C = ' ' do C := s.readChar;
        except on TStreamException do
            raise TEvalException.Create('Ȃ');
        end;
        if C = '+' then begin
            sign := 1;
        end else if C = '-' then begin
            sign := -1;
        end else begin
            s.unreadChar;
        end;
        Factor(r,s);
        try
            C := s.readChar;
            while C = ' ' do C := s.readChar;
        except on TStreamException do
            ;
        end;
        if C = '^' then begin
            Factor1(W, s);
            r.ruijo(W);
        end else begin
            s.unreadChar;
        end;
    finally
        r.sign := r.sign*sign;
        W.free;
    end;
end;
{----------------
  Term
-----------------}
procedure Term(r:TloRational; s:StringStream);
  var
      W: TloRational;
      C:Char;
begin
    W := TloRational.Create(0,1);
    try
        Factor1(r, s);
        try
            C := s.readChar;
            while C in ['*', '/', ' ', ';'] do begin
                case C of
                  ';' : break;
                  ' ' : ;
                  '*' : begin
                          Factor1(W, s);
                          r.kakeru(W);
                        end;
                  else begin
    	              Factor1(W, s);
    	              if not W.iszero then
    	                  r.waru(W)
    	              else
    	                  raise TEvalException.Create('0Ŋ낤Ƃ');
                  end;
                end;
                C := s.readChar;
            end;
            s.unreadChar;
        except on TStreamException do ;
        end;
    finally
        W.free;
    end;
end;
{--------------------
 Expression
--------------------}
procedure Expression(r:TloRational; s:StringStream);
    var w:TloRational;
        C:Char;
begin
    w := TloRational.Create(0,1);
    try
        Term(r, s);
        try
            C := s.readChar;
            while C in ['+', '-', ' ', ';'] do begin
	        case C of
	            '+': begin
                        Term(w, s);
		        r.tasu(w);
	            end;
	            '-': begin
                        Term(w, s);
		        r.hiku(w);
	            end;
                    ' ':begin
                        ;
                    end;
                    ';':begin
                        break;
                    end;
	        end;
                C := s.readChar;
            end;
            s.unreadChar;
        except on TStreamException do ;
        end;
    finally
        w.free
    end;
end;
end.
