unit BunDispCal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, stream, shiki;

type
  TBunDispCalc = class
  private
    { Private 錾 }
    canvas:TCanvas;
    txt:string;
    left:Integer;
    top:Integer;
    right:Integer;
    bottom:Integer;
    center:Integer;
    base:Integer;
    upBase:Integer;
    loBase:Integer;
    ruiBaseS:Integer;
    ruiBaseB:Integer;
    fontsize:Integer;
    zeroheight:Integer;
    onewidth:Integer;
    sl:TShiki;
    procedure clear;
    procedure baseSet;
    procedure parse(s:string);
    procedure writeText(s:string);
    procedure writeTx(s:string);
    procedure writeRui(s:string;base:Integer);
    procedure writeBun(bo,shi:string);
    procedure writeParen(s:string);
    procedure TextOut(x,y,w:Integer; s:string);
    procedure writeJunkan(s:string);
    function readNum(s:StringStream):string;
    function readExp(s:StringStream):string;
    function readString(s:StringStream):string;
  protected
    { Protected 錾 }
  public
    { Public 錾 }
    procedure write(can:TCanvas;l,t,r,b:Integer;s:String);
    constructor Create(AOwner: TComponent);
    destructor Destroy; override;
  published
    { Published 錾 }
  end;

implementation
{}
{---------------------
  ől
 ---------------------}
function max(x, y:LongInt):LongInt;
begin
    if x > y then result := x
    else result := y;
end;

{---------------------
  ŏl
 ---------------------}
function min(x, y:LongInt):LongInt;
begin
    if x > y then result := y
    else result := x;
end;

{---------------------
  
 ---------------------}
constructor TBunDispCalc.Create(AOwner: TComponent);
begin
   inherited Create;
   sl := TShiki.Create;
end;

{---------------------
   sl͕̉KvȂ͂
 ---------------------}
destructor TBunDispCalc.Destroy;
begin
   sl.free;
   inherited Destroy;
end;

{---------------------
    \̃NA
 ---------------------}
procedure TBunDispCalc.Clear;
begin
    Canvas.FillRect(Rect(left, top, right, bottom));
    Canvas.moveto(2, 0);
end;

{--------------------------
  Ȃǂ̕\ʒuvZ
 --------------------------}
procedure TBunDispCalc.baseSet;
var h:Integer;
begin
    zeroheight := Canvas.textHeight('0');
    onewidth := Canvas.textWidth('1');
    h := zeroheight;
    center := h+ h div 2 + 3;
    base := center - h div 2;
    upBase := center - h-1;
    loBase := center + 2;
    ruiBaseB := upBase - h div 4;
    ruiBaseS := base - h div 4;
end;

{---------------------
  ̉
  łdvȕ
 ---------------------}
procedure TBunDispCalc.parse(s:string);
var
    c:Char;
    w:string;
    ss:StringStream;
begin
    ss := StringStream.fromstring(s);
    try
    while not ss.isEOF do begin
        c := ss.readChar;
        case c of
        ' ': begin ; end;
        ';': begin break; end;
        '(',')': begin
           sl.add(kakko,c,'');
        end;
        '[': begin
           if not ss.isEOF then begin
               sl.add(junkan,readNum(ss),'');
           end else begin
               sl.add(kigou,c,'');
           end;
        end;
        ']':begin ; end;
        '+','-','*','/':begin
           sl.add(kigou,c,'');
        end;
        '0'..'9': begin
           ss.unreadChar;
           w := readNum(ss);
           if (not ss.isEOF)and (ss.peepChar = '/') then begin
               ss.readChar;
               sl.add(bunsu,w,readNum(ss));
           end else if ss.peepChar = '.' then begin
               sl.add(kigou,w+readString(ss),'');
           end else begin
               sl.add(seisu,w,'');
           end;
        end;
        '^': begin
           if (not ss.isEOF)and (ss.peepChar in ['-','0'..'9']) then begin
               w := readNum(ss);
               if (not ss.isEOF)and (ss.peepChar = '/') then begin
                  ss.readChar;
                  sl.add(ruijo,w+'/'+readNum(ss),'');
               end else begin
                  sl.add(ruijo,w,'');
               end;
           end else if (ss.peepChar = '(' )then begin
               ss.readChar;
               sl.add(ruijo, readExp(ss),'');
           end else begin
               sl.add(kigou,c,'');
           end;
          end;
        else begin
           ss.unreadChar;
           sl.add(kigou,readString(ss),'');
           end;
        end;
    end;
    finally
    ss.free;
    end;
end;

{---------------------
  ̓ǂݎ
 ---------------------}
function TBunDispCalc.readNum(s:StringStream):string;
var c:Char;
begin
    Result :='';
    if (not s.isEOF) and (s.peepChar in ['+','-']) then begin
        Result := Result + s.readChar;
    end;
    while not s.isEOF do begin
        c := s.readChar;
        if not (c in ['0'..'9']) then begin
            s.unreadChar;
            break;
        end;
        Result := Result + c;
    end;
end;

{---------------------
  ݏ敔̓ǂݎ
 ---------------------}
function TBunDispCalc.readExp(s:StringStream):string;
var c:Char;
begin
    Result :='';
    while not s.isEOF do begin
        Result := Result + readString(s);
        c := s.readChar;
        if (c = ')')or(c=';') then begin
            break;
        end;
        Result := Result + c;
    end;
end;

{---------------------
  ǂݎ
 ---------------------}
function TBunDispCalc.readString(s:StringStream):string;
var c:Char;
    i:Integer;
begin
    Result :='';
    while not s.isEOF do begin
        c := s.readChar;
	i := ord(c);
        if (($81 <= i) and (i <= $9F)) or
           (($E0 <= i) and (i <= $EF)) then begin
            Result := Result + c + s.readChar;
            continue;
        end;
        if c in ['+','-','*','/','(',')','^',' ','[',']',';'] then begin
        {if c in ['(',')',';'] then begin}
            s.unreadChar;
            break;
        end;
        Result := Result + c;
    end;
end;

{-----------------------------
  ǑĂяo
 -----------------------------}
procedure TBunDispCalc.write(can:TCanvas;l,t,r,b:Integer;s:String);
begin
    left := l;
    top := t;
    right := r;
    bottom := b;
    Canvas := can;
    txt := s;
    fontsize := Canvas.font.size;
    BaseSet;
    //Clear;
    writeText(s);
end;
{-----------------------------
  textvpeB̕\
 -----------------------------}
procedure TBunDispCalc.writeText(s:string);
var k:kokubun;
    ruicnt:Integer;
    p:pelm;
begin
    Clear;
    sl.clear;
    if s = '' then begin
        Exit;
    end;
    parse(s);
    ruicnt := 0;
    k := owari;
    p := sl.read;
    while p <> nil do begin
        case p^.t of
        bunsu : begin
            writeBun(p^.bo, p^.shi);
            end;
        kakko: begin
            writeParen(p^.shi);
            end;
        ruijo: begin
            if (k = bunsu)or(k=kakko) then begin
                writeRui(p^.shi,ruiBaseB-2*ruicnt);
            end else begin
                writeRui(p^.shi,ruiBaseS-2*ruicnt);
            end;
        end;
        junkan: begin
            writeJunkan(p^.shi);
        end;
        else begin
            writeTx(p^.shi);
        end;
        end;
        if p^.t = ruijo then begin
            ruicnt := ruicnt +1;
        end else begin
            k := p^.t;
            ruicnt := 0;
        end;
        p := sl.read;
    end;
end;

{---------------------
  \iL܂ށj
 ---------------------}
procedure TBunDispCalc.writeTx(s:string);
var p:Tpoint;
begin
    p := Canvas.PenPos;
    if p.x > right then exit;
    if s = '*' then s := '~';
    if s = '/' then s := '';
    if s = '-' then s := '|';
    if s = '+' then s := '{';
    if length(s) < 50 then begin
       Canvas.textOut(p.x+2, base, s);
    end else begin
       textOut(p.x+2, base, right, s);
    end;
end;

{---------------------
  z\
 ---------------------}
procedure TBunDispCalc.writeJunkan(s:string);
var p:Tpoint;
    bx,by,bw:Integer;
    e:string;
    c:TColor;
begin
    p := Canvas.PenPos;
    if p.x > right then exit;
    if s = '' then begin
       Canvas.textOut(p.x+2, base, '[');
       exit;
    end;
    by := ZeroHeight div 5;
    bx := Canvas.Textwidth('0') div 3;
    bw := ZeroHeight div 8;
    Canvas.textOut(p.x+2, base, s[1]);
    if bw <= 1 then begin
        c := Canvas.Brush.Color;
        try
            Canvas.Brush.Color := Canvas.Font.Color;
            Canvas.FillRect(Rect(p.x+2+bx,base-by-bw,p.x+2+bx+bw,base-by));
        finally
            Canvas.Brush.Color := c;
        end;
    end else begin
        Canvas.Ellipse(p.x+2+bx,base-by-bw,p.x+2+bx+bw,base-by);
    end;
    p := Canvas.PenPos;
    if length(s) > 1 then begin
      e := s[length(s)];
    end else begin
      e := '';
    end;
    s := copy(s, 2, length(s)-2);
    if length(s) < 50 then begin
       Canvas.textOut(p.x+2, base, s);
    end else begin
       textOut(p.x+2, base, right, s);
    end;
    if e = '' then exit;
    p := Canvas.PenPos;
    Canvas.textOut(p.x+2, base, e);
    Canvas.Ellipse(p.x+2+bx,base-by-bw,p.x+2+bx+bw,base-by);
end;
{---------------------
  ݏ̕\
 ---------------------}
procedure TBunDispCalc.writeRui(s:string;base:Integer);
var p:Tpoint;
begin
    try
      if s <> '' then begin
        Canvas.Font.size := fontsize div 2 +1;
        p := Canvas.PenPos;
        if p.x > right then exit;
        Canvas.textOut(p.x+2, base, s);
      end;
    finally
    Canvas.Font.size := fontsize;
    end;
end;

{---------------------
  ʂ̕\
 ---------------------}
procedure TBunDispCalc.writeParen(s:string);
var p:Tpoint;
    t,l,b,r,sx,sy,ex,ey,h,m:Integer;
begin
    p := Canvas.PenPos;
    if p.x > right then exit;
    h := zeroheight div 2;
    m := h div 2;
    t := upBase-h div 2;
    l := p.x +2;
    b := center + zeroheight+h div 2;
    r := l + zeroheight;
    sx := l + h;
    sy := top;
    ex := sx;
    ey := b;
    if s = '(' then begin
      Canvas.arc(l,t,r,b,sx-m,sy+m,ex-m,ey-m);
      Canvas.moveto(sx-2,b);
    end else begin
      Canvas.arc(l-h,t,r-h,b,ex-h+m,ey-m,sx-h+m,sy+m);
      Canvas.moveto(sx,b);
    end;
end;

{---------------------
  ̕\
 ---------------------}
procedure TBunDispCalc.writeBun(bo,shi:string);
var p:Tpoint;
    x, bl, sl, l:LongInt;
begin
    p := Canvas.PenPos;
    if p.x > right then exit;
    x := p.x + 4;
    bl := Canvas.TextWidth(bo);
    sl := Canvas.TextWidth(shi);
    l := max(bl, sl);
    if x + l > right then begin
    end;
    Canvas.moveto(x, center);
    {Canvas.Pen.color := clBlack;
    Canvas.Pen.Width := 1;}
    Canvas.lineto(min(x+l+4,right), center);
    TextOut(x+(l-sl)div 2+3, upBase, right, shi);
    TextOut(x+(l-bl)div 2+3, loBase, right, bo);
    Canvas.moveto(x+l+4, p.y);
end;

{---------------------
  ͈͕̔ttextout
 ---------------------}
procedure TBunDispCalc.TextOut(x,y,w:Integer; s:string);
var i,l:Integer;
begin
    for i := 1 to length(s) do begin
        if x > w then exit;
        l := Canvas.TextWidth(s[i]);
        Canvas.textOut(x, y, s[i]);
        x := x + l;
    end;
 end;

end.
