unit BunEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, stream, shiki;

type
  TBunEdit = class(TImage)
  private
    { Private 錾 }
    txt:string;
    center:Integer;
    base:Integer;
    upBase:Integer;
    loBase:Integer;
    ruiBaseS:Integer;
    ruiBaseB:Integer;
    fontsize:Integer;
    zeroheight:Integer;
    sl:TShiki;
    procedure clear;
    procedure baseSet;
    procedure parse(s:string);
    procedure setText(s:string);
    procedure writeText(s:string);
    procedure writeTx(s:string);
    procedure writeRui(s:string;base:Integer);
    procedure writeBun(bo,shi:string);
    procedure writeParen(s:string);
    procedure TextOut(x,y,w:Integer; s:string);
    function getText:string;
    function readNum(s:StringStream):string;
    function readExp(s:StringStream):string;
    function readString(s:StringStream):string;
  protected
    { Protected 錾 }
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property text:string read getText write setText;
  published
    { Published 錾 }
  end;

{procedure Register;}
{function max(x, y:LongInt):LongInt;}

implementation
{}
{---------------------
  ől
 ---------------------}
function max(x, y:LongInt):LongInt;
begin
    if x > y then result := x
    else result := y;
end;

{---------------------
  ŏl
 ---------------------}
function min(x, y:LongInt):LongInt;
begin
    if x > y then result := y
    else result := x;
end;

{---------------------
  
 ---------------------}
constructor TBunEdit.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   sl := TShiki.Create;
   width:=2000;      {ȂƂ̌㉡ύXłȂ}
   Canvas.Font.Assign((AOwner as TForm).font);
   fontsize := Canvas.Font.size;
   Canvas.Brush.Style := bsSolid;
   Canvas.Brush.Color := clWhite;
   baseSet;
   Clear;
end;

{---------------------
   sl͕̉KvȂ͂
 ---------------------}
destructor TBunEdit.Destroy;
begin
   sl.free;
   inherited Destroy;
end;

{---------------------
    \̃NA
 ---------------------}
procedure TBunEdit.Clear;
begin
    Canvas.FillRect(Rect(0,0,width,height));
    Canvas.moveto(2, 0);
end;

{--------------------------
  Ȃǂ̕\ʒuvZ
 --------------------------}
procedure TBunEdit.baseSet;
var h:Integer;
begin
    zeroheight := Canvas.textHeight('0');
    h := zeroheight;
    Height := h * 3 + 6;
    center := h+ h div 2 + 3;
    base := center - h div 2;
    upBase := center - h-1;
    loBase := center + 2;
    ruiBaseB := upBase - h div 4;
    ruiBaseS := base - h div 4;
end;

{---------------------
  ̉
  łdvȕ
 ---------------------}
procedure TBunEdit.parse(s:string);
var
    c:Char;
    w:string;
    ss:StringStream;
begin
    ss := StringStream.fromstring(s);
    try
    while not ss.isEOF do begin
        c := ss.readChar;
        case c of
        ' ': begin ; end;
        ';': begin break; end;
        '(',')': begin
           sl.add(kakko,c,'');
        end;
        '+','-','*','/':begin
           sl.add(kigou,c,'');
        end;
        '0'..'9': begin
           ss.unreadChar;
           w := readNum(ss);
           if (not ss.isEOF)and (ss.peepChar = '/') then begin
               ss.readChar;
               sl.add(bunsu,w,readNum(ss));
           end else if ss.peepChar = '.' then begin
               sl.add(kigou,w+readString(ss),'');
           end else begin
               sl.add(seisu,w,'');
           end;
        end;
        '^': begin
           if (not ss.isEOF)and (ss.peepChar in ['0'..'9']) then begin
               sl.add(ruijo,readNum(ss),'');
           end else if (ss.peepChar = '(' )then begin
               ss.readChar;
               sl.add(ruijo, readExp(ss),'');
           end else begin
               sl.add(kigou,c,'');
           end;
          end;
        else begin
           ss.unreadChar;
           sl.add(kigou,readString(ss),'');
           end;
        end;
    end;
    finally
    ss.free;
    end;
end;

{---------------------
  ̓ǂݎ
 ---------------------}
function TBunEdit.readNum(s:StringStream):string;
var c:Char;
begin
    Result :='';
    while not s.isEOF do begin
        c := s.readChar;
        if not (c in ['0'..'9']) then begin
            s.unreadChar;
            break;
        end;
        Result := Result + c;
    end;
end;

{---------------------
  ݏ敔̓ǂݎ
 ---------------------}
function TBunEdit.readExp(s:StringStream):string;
var c:Char;
begin
    Result :='';
    while not s.isEOF do begin
        Result := Result + readString(s);
        c := s.readChar;
        if (c = ')')or(c=';') then begin
            break;
        end;
        Result := Result + c;
    end;
end;

{---------------------
  ǂݎ
 ---------------------}
function TBunEdit.readString(s:StringStream):string;
var c:Char;
    i:Integer;
begin
    Result :='';
    while not s.isEOF do begin
        c := s.readChar;
	i := ord(c);
        if (($81 <= i) and (i <= $9F)) or
           (($E0 <= i) and (i <= $EF)) then begin
            Result := Result + c + s.readChar;
            continue;
        end;
        if c in ['+','-','*','/','(',')','^',' ',';'] then begin
        {if c in ['(',')',';'] then begin}
            s.unreadChar;
            break;
        end;
        Result := Result + c;
    end;
end;

{--------------------------
  textvpeB̓ǂݏo
 --------------------------}
function TBunEdit.getText() :string;
begin
    Result := txt;
end;


{-----------------------------
  textvpeB̕ύX̏
 -----------------------------}
procedure TBunEdit.setText(s:string);
begin
    txt := s;
    writeText(txt);
end;
{-----------------------------
  textvpeB̕\
 -----------------------------}
procedure TBunEdit.writeText(s:string);
var k:kokubun;
    ruicnt:Integer;
    p:pelm;
begin
    Clear;
    sl.clear;
    if s = '' then begin
        Exit;
    end;
    parse(s);
    ruicnt := 0;
    k := owari;
    p := sl.read;
    while p <> nil do begin
        case p^.t of
        bunsu : begin
            writeBun(p^.bo, p^.shi);
            end;
        kakko: begin
            writeParen(p^.shi);
            end;
        ruijo: begin
            if (k = bunsu)or(k=kakko) then begin
                writeRui(p^.shi,ruiBaseB-2*ruicnt);
            end else begin
                writeRui(p^.shi,ruiBaseS-2*ruicnt);
            end;
        end;
        else begin
            writeTx(p^.shi);
        end;
        end;
        if p^.t = ruijo then begin
            ruicnt := ruicnt +1;
        end else begin
            k := p^.t;
            ruicnt := 0;
        end;
        p := sl.read;
    end;
end;

{---------------------
  \iL܂ށj
 ---------------------}
procedure TBunEdit.writeTx(s:string);
var p:Tpoint;
begin
    p := Canvas.PenPos;
    if p.x > width then exit;
    if s = '*' then s := '~';
    if s = '/' then s := '';
    if s = '-' then s := '|';
    if s = '+' then s := '{';
    Canvas.textOut(p.x+2, base, s);
end;

{---------------------
  ݏ̕\
 ---------------------}
procedure TBunEdit.writeRui(s:string;base:Integer);
var p:Tpoint;
begin
    try
      if s <> '' then begin
        Canvas.Font.size := fontsize div 2 +1;
        p := Canvas.PenPos;
        if p.x > width then exit;
        Canvas.textOut(p.x+2, base, s);
      end;
    finally
    Canvas.Font.size := fontsize;
    end;
end;

{---------------------
  ʂ̕\
 ---------------------}
procedure TBunEdit.writeParen(s:string);
var p:Tpoint;
    top,left,bottom,right,sx,sy,ex,ey,h:Integer;
begin
    p := Canvas.PenPos;
    if p.x > width then exit;
    h := zeroheight div 2;
    top := upBase;
    left := p.x +2;
    bottom := center + zeroheight;
    right := left + zeroheight;
    sx := left + h;
    sy := top;
    ex := sx;
    ey := bottom;
    if s = '(' then begin
      Canvas.arc(left,top,right,bottom,sx-2,sy,ex-2,ey);
      Canvas.moveto(sx-2,bottom);
    end else begin
      Canvas.arc(left-h,top,right-h,bottom,ex-h+2,ey,sx-h+2,sy);
      Canvas.moveto(sx,bottom);
    end;
end;

{---------------------
  ̕\
 ---------------------}
procedure TBunEdit.writeBun(bo,shi:string);
var p:Tpoint;
    x, bl, sl, l:LongInt;
begin
    p := Canvas.PenPos;
    if p.x > width then exit;
    x := p.x + 4;
    bl := Canvas.TextWidth(bo);
    sl := Canvas.TextWidth(shi);
    l := max(bl, sl);
    if x + l > width then begin
    end;
    Canvas.moveto(x, center);
    Canvas.Pen.color := clBlack;
    Canvas.Pen.Width := 1;
    Canvas.lineto(min(x+l+4,width), center);
    TextOut(x+(l-sl)div 2+3, upBase, width, shi);
    TextOut(x+(l-bl)div 2+3, loBase, width, bo);
    Canvas.moveto(x+l+4, p.y);
end;

{---------------------
  ͈͕̔ttextout
 ---------------------}
procedure TBunEdit.TextOut(x,y,w:Integer; s:string);
var i,xx,l:Integer;
begin
    xx := x;
    for i := 1 to length(s) do begin
        if xx > w then exit;
        l := Canvas.TextWidth(s[i]);
        Canvas.textOut(xx, y, s[i]);
        xx := xx + l;
    end;
 end;

{procedure Register;
begin
  RegisterComponents('Samples', [TBunEdit]);
end;}

end.
