unit testlrat;

interface

implementation
uses lrat, TestFrameWork, stream;

type
  TlratTest = class(TTestCase)
  published
    procedure testReadFromStream;
    procedure testGyakusu;
    procedure testFractMaxDigits;
    procedure testAsFract2;
end;

procedure TlratTest.testReadFromStream;
var
    aRational:TLoRational;
    aStream:StringStream;
    bs:StringStream;
begin
    aRational := TLoRational.Create(0,1);
    aStream := StringStream.fromString('3/4');
    bs := StringStream.fromString('2.[3]');
    try
        aRational.readFromStream(aStream);
        Check(aRational.asString = '3/4', '3/4');
        aRational.readFromStream(bs);
        Check(aRational.asString = '8/3', '7/3');
    finally
        aRational.free;
        bs.free;
        aStream.free;
    end;
end;

procedure TlratTest.testGyakusu;
var
    aRational:TLoRational;
begin
    aRational := TLoRational.Create(2,3);
    try
        aRational.gyakusu;
        Check(aRational.asString = '3/2');
    finally
        aRational.free;
    end;
end;

procedure TlratTest.testFractMaxDigits;
var
    aRational:TLoRational;
    str:string;
begin
    aRational := TLoRational.Create(1,7);
    try
        TLoRational.setDefaultFractMaxDigits(5);
        Check(TLorational.getDefaultFtactMaxDigits = 5);
        str := aRational.asFraction2(false);
        Check(length(str) = 7);
        Check(TLorational.getDefaultFtactMaxDigits = 5);
        str := aRational.asFraction2(false, 12);
        Check(length(str) = 14);
        str := aRational.asFraction2(false, 300);
        Check(length(str) = 302);
        //z̏ꍇɂ͍lĂȂ
        //@todo z̔ȂƂ悤ɂ悤
        //str := aRational.asFraction2(true, 3);
        //Test(length(str), 5);
    finally
        aRational.free;
    end;
end;

procedure TlratTest.testAsFract2;
var
    aRational, bRational, cRational, dRational, eRational:TLoRational;
begin
    aRational := TLoRational.Create(7,1);
    bRational := TLoRational.Create(9,8);
    cRational := TLoRational.Create(-7,1);
    dRational := TLoRational.Create(-9,8);
    eRational := TLoRational.Create(-10,3);
    try
        Check(aRational.asFraction2(false) = '7');
        Check(bRational.asFraction2(false) = '1.125');
        Check(cRational.asFraction2(false) = '-7');
        Check(dRational.asFraction2(false) = '-1.125');
        Check(eRational.asFraction2(true) = '-3.[3]');
    finally
        aRational.free;
        bRational.free;
    end;
end;

initialization
  TestFramework.RegisterTest(TlratTest.Suite);
end.
